DROP PROCEDURE [hips].[HL7MessageLogGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date: 25 July 2012
-- Description:   Gets a specified record from the HL7Message Table
-- Modified:
-- 16/04/2013 - sbiber - Get only the most recently created record with the criteria
--                       Column IsSuccessful bit changed to QueueStatusId int
-- =============================================
CREATE PROCEDURE [hips].[HL7MessageLogGet] 
(
		 @HL7MessageLogId INT = NULL
		,@SendingApplication		 varchar(180) =NULL
		,@SendingFacility		     varchar(180) = NULL
		,@MessageControlId		     varchar(25) = NULL
		,@MessageTime	DATETIME = NULL      
) AS
BEGIN

SELECT TOP 1
		[HL7MessageLogId]
       ,[HospitalId]
       ,[HospitalPatientIdentifier]
       ,[SendingApplication]
       ,[SendingFacility]
       ,[MessageControlId]
       ,[DateTimeOfMessage]
       ,[QueueStatusId]
       ,[ShouldRetry]
       ,[RetryCount]
       ,[FailureReason]
       ,[FullMessage]
       ,[DateCreated]
       ,[UserCreated]
       ,[DateModified]
       ,[UserModified]
FROM [hips].[HL7MessageLog] 
WHERE (@HL7MessageLogId IS NULL OR HL7MessageLogId = @HL7MessageLogId)
AND (@SendingApplication IS NULL OR SendingApplication = @SendingApplication)
AND (@SendingFacility IS NULL OR SendingFacility = @SendingFacility)
AND (@MessageControlId IS NULL OR MessageControlId = @MessageControlId)
AND (@MessageTime IS NULL OR DateTimeOfMessage = @MessageTime)
ORDER BY DateCreated DESC

END

GO

